# struct.filter()

This function creates a new Struct that returns all entries from an struct that match the given filter.

```
struct.filter( filter=function, parallel=boolean, maxThreads=number )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| filter | function | Yes | A function/closure that implements the following constructor `function(any key, any value) { return true/false; }` |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	animals = {
		cow: "moo",
		pig: "oink",
		snail: ""
	};
	// Show all animals
	Dump(
		label: "All animals",
		var: animals
	);
	// Get animals that make noise
	noisyAnimals = animals.filter(function(key) {
		// If the key has a value return true (noisy animal)
		if (animals[arguments.key].len()) {
			return true;
		}
		return false;
	});
	Dump(
		label: "Noisy Animals",
		var: noisyAnimals
	);
	// Get animals that are quiet
	quietAnimals = animals.filter(function(key) {
		// If the key has a value return true (quiet animal)
		if (! animals[arguments.key].len()) {
			return true;
		}
		return false;
	});
	Dump(
		label: "Quiet Animals",
		var: quietAnimals
	);
```

# Categories

[Structures](../../../categories/struct.md), [Iterator](../../../categories/iterator.md)

# See Also

[StructFilter()](../../functions/structfilter.md), [Struct](../struct.md)