# struct.every()

This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.

```
struct.every( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor `function(key, value, st){}` and returns a boolean value *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	animals = {
		cow: "moo",
		pig: "oink",
		cat: "meow"
	};
	// Use every() to iterate over keys in struct. Closure returns true/false.
	allAnimalsAreNoisy = animals.every(function(key) {
		// If the key has a value return true (noisy animal)
		if (animals[arguments.key].len()) {
		return true;
		}
		return false;
	});
	Dump(
		label: "allAnimalsAreNoisy",
		var: allAnimalsAreNoisy
	);
	// Use every() to iterate over keys in struct. Closure returns true/false.
	allAnimalsAreQuiet = animals.every(function(key) {
		// If the key is blank return true (quiet animal)
		if (! animals[arguments.key].len()) {
			return true;
		}
		return false;
	});
	Dump(
		label: "allAnimalsAreQuiet",
		var: allAnimalsAreQuiet
	);
```

# Categories

[Iterator](../../../categories/iterator.md), [Structures](../../../categories/struct.md), [Threads](../../../categories/thread.md)

# See Also

[StructEvery()](../../functions/structevery.md), [Struct](../struct.md)