# struct.each()

call the given UDF/Closure with every entry (key/value) in the struct.

```
struct.each( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | A closure function (UDF) with the following signature: `function(key, value, st){}` Which is called for each item in the struct. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	animals = {
		cow: "moo",
		pig: "oink",
		cat: "meow"
	};
	animals.each(function(key) {
		// Show key 'arguments.key'
		Dump(
			label: "Key",
			var: arguments.key
		);
		// Show key's value 'animals[arguments.key]'
		Dump(
			label: arguments.key & "'s value",
			var: animals[arguments.key]
		);
	});
```

# Categories

[Iterator](../../../categories/iterator.md), [Structures](../../../categories/struct.md), [Threads](../../../categories/thread.md)

# See Also

[StructEach()](../../functions/structeach.md), [Struct](../struct.md)