# struct.duplicate()

Returns a new duplicated version of the given object, removing all references to the old one

```
struct.duplicate( deepCopy=boolean )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| deepCopy | boolean | No | if set to true (default) also the child elements are cloned, otherwise the child elements are still the same as in the original object |  |

# Examples

```cfml
	animals = {1:"tiger",2:{5:'lion',6:'deer'},3:"wolf",4:"dog"};
	writeDump(animals);
	res = animals.duplicate();
	writeDump(res);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[Duplicate()](../../functions/duplicate.md), [Struct](../struct.md)