# struct.delete()

Removes an element from a structure.

Since Lucee 6, this member function `.delete()` now returns the modified struct

```
struct.delete( key=string, indicateNotExisting=boolean )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key | string | Yes | Element to remove |  |
| indicateNotExisting | boolean | No | Whether to show an error if the key does not exist *Alias: indicateExists* |  |

# Examples

```cfml
	animals = {
	    cow: "moo",
	    pig: "oink",
	    cat: "meow"
 	 };
	// Show current animals
	Dump(
		label: "Current animals",
		var: animals
	);
	// Delete the key 'cat' from struct
	animals.delete("cat");
	// Show animals, cat has been deleted
	Dump(
		label: "Animals with cat deleted",
		var: animals
	);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructDelete()](../../functions/structdelete.md), [Struct](../struct.md)