# struct.copy()

Copies a structure. Copies top-level keys, values, and arrays
in the structure by value; copies nested structures by
reference.

```
struct.copy( )
```

**Returns:** object

*This function does not take any arguments.*

# Examples

```cfml
	animals = {
		cow: "moo",
		pig: "oink"
	};
	// Show current animals
	Dump(
		label: "Current animals",
		var: animals
	);
	// Copy animals struct to farm
	farm = animals.copy();
	// Show farm, looks like animals
	Dump(
		label: "Farm after animals.copy()",
		var: farm
	);
	// Add another animal. Will not affect farm.
	animals.append({
		cat: "meow"
	});
	// Show animals, now includes cat
	Dump(
		label: "Animals with cat added",
		var: animals
	);
	// Show farm, does not have cat
	Dump(
		label: "Farm copied from animals before cat was added",
		var: farm
	);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructCopy()](../../functions/structcopy.md), [Struct](../struct.md)