# Struct

Object

- [struct.append()](struct/append.md) - Appends all the data from struct2 into struct2, replacing duplicate keys unless specified by the overwrite flag
- [struct.clear()](struct/clear.md) - Removes all data from a structure.
- [struct.copy()](struct/copy.md) - Copies a structure. Copies top-level keys, values, and arrays
in the structure by value; copies nested structures by
reference.
- [struct.delete()](struct/delete.md) - Removes an element from a structure.
- [struct.duplicate()](struct/duplicate.md) - Returns a new duplicated version of the given object, removing all references to the old one
- [struct.each()](struct/each.md) - call the given UDF/Closure with every entry (key/value) in the struct.
- [struct.every()](struct/every.md) - This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.
- [struct.filter()](struct/filter.md) - This function creates a new Struct that returns all entries from an struct that match the given filter.
- [struct.find()](struct/find.md) - Determines the value associated with a key in a structure.
- [struct.findKey()](struct/findkey.md) - Searches recursively through a substructure of nested arrays,
structures, and other elements, for structures whose values
match the search key in the value parameter.
- [struct.findValue()](struct/findvalue.md) - Searches recursively through a substructure of nested arrays,
structures, and other elements for structures with values that
match the search key in the value parameter.
- [struct.insert()](struct/insert.md) - Inserts a key-value pair into a structure.
- [struct.isEmpty()](struct/isempty.md) - Determines whether a structure contains data.
- [struct.keyArray()](struct/keyarray.md) - Returns an array of the keys from a structure
- [struct.keyExists()](struct/keyexists.md) - Determines whether a specific key is present in a structure.
- [struct.keyList()](struct/keylist.md) - Extracts keys from a struct.
- [struct.keyTranslate()](struct/keytranslate.md) - Converts any struct keys with dot notation into nested structures
- [struct.len()](struct/len.md) - Counts the keys in a structure.
- [struct.map()](struct/map.md) - Calls the given closure with every element in the given struct.
the function returns a struct that contains all values returned by the closure.
- [struct.reduce()](struct/reduce.md) - Iterates over every entry of the given struct and calls the closure with every key/value. 
This function will reduce the struct to a single value and will return this value.
- [struct.some()](struct/some.md) - This function calls a closure/function on every element in a struct until one returns true.
- [struct.sort()](struct/sort.md) - Returns a sorted array of the top level keys in a structure.
Sorts using alphabetic or numeric sorting, and can sort based
on the values of any structure element.
- [struct.toSorted()](struct/tosorted.md) - Returns a struct sorted by the top level keys in a structure.
Sorts using alphabetic or numeric sorting.
- [struct.update()](struct/update.md) - Updates a key with a value.
- [struct.valueArray()](struct/valuearray.md) - Returns an Array with the values of the Struct

# Categories

[Objects](../../categories/object.md), [Structures](../../categories/struct.md)

# See Also

[StructNew()](../functions/structnew.md)