# string.wrap()

Wraps text so that each line has a specified maximum number of characters.

```
string.wrap( limit=number, strip=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| limit | number | Yes | Positive integer maximum number of characters to allow on a line. |  |
| strip | boolean | No | Whether to remove all existing newline and carriage return characters in the input string with spaces before wrapping the text. |  |

# Examples

```cfml
string = "Thewayaredifbutdesareone";
res = string.wrap(3);
writeDump(res);
string2 = "onetwosixten";
res = string2.wrap(3);
writeDump(res);
string3 = "this is a string"
res = string3.wrap(4);
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[Wrap()](../../functions/wrap.md), [String](../string.md)