# string.uRLEncodedFormat()

Generates a URL-encoded string. For example, it replaces spaces
with %20, and non-alphanumeric characters with equivalent
hexadecimal escape sequences. Passes arbitrary strings within a
URL.

```
string.uRLEncodedFormat( charset=string, force=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| charset | string | No | The character encoding in which the string is encoded. |  |
| force | boolean | No | If false, then the string will not be encoded if it does not contain unsafe characters. |  |

# Examples

```cfml
url_string = "https://dev.lucee.org/t/welcome-to-lucee-dev/2064";
dump(url_string.URLEncodedFormat()); // https%3A%2F%2Fdev%2Elucee%2Eorg%2Ft%2Fwelcome%2Dto%2Dlucee%2Ddev%2F2064
```

# Categories

[Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md)

# See Also

[URLEncodedFormat()](../../functions/urlencodedformat.md), [String](../string.md)