# string.URLEncode()

Encodes a string to be URL-safe according to the application/x-www-form-urlencoded MIME format

```
string.URLEncode( charset=string, force=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| charset | string | No | The World Wide Web Consortium Recommendation states that UTF-8 should be used as per <https://www.w3.org/TR/html40/appendix/notes.html#non-ascii-chars>. - Using different charsets may cause incompatibilities with other systems. |  |
| force | boolean | No | If false, then the string will not be encoded if it does not contain unsafe characters. |  |

# Examples

```cfml
urlString = "https://dev.lucee.org/t/welcome-to-lucee-dev/2064";
dump(urlString.URLEncode()); // https%3A%2F%2Fdev.lucee.org%2Ft%2Fwelcome-to-lucee-dev%2F2064
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[URLEncode()](../../functions/urlencode.md), [String](../string.md)