# string.uRLDecode()

Decodes a URL-encoded string.

```
string.uRLDecode( charset=string, strict=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| charset | string | No | The character encoding in which the string is encoded. |  |
| strict | boolean | No | Default *true*, uses the Apache Commons UrlDecoder which has better overall support for UTF-8 etc, but throws an exception on invalid encodings. When **false**, it will attempt strict mode first, then fall back to the older custom implementation which strips out invalid encodings, if strict fails. |  |

# Examples

```cfml
	encoded_string = "https%3A%2F%2Fdev%2Elucee%2Eorg%2Ft%2Fwelcome%2Dto%2Dlucee%2Ddev%2F2064";
	dump(encoded_string.URLDecode()); // https://dev.lucee.org/t/welcome-to-lucee-dev/2064
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[URLDecode()](../../functions/urldecode.md), [String](../string.md)