# string.ucFirst()

Capitalizes the first character of the given string.

```
string.ucFirst( doAll=boolean, doLowerIfAllUppercase=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| doAll | boolean | No | If true, then every word is capitalized, where a new word is defined as alpha characters that come after whitespace, a dot [.], a dash [-], or (parenthesis). This is especially useful to clean up user input of names, e.g. converting a string like "susi q. sorgolis" to "Susi Q. Sorgolis" |  |
| doLowerIfAllUppercase | boolean | No | If true, then if the input string contains letters and they are all UPPERCASE, then the input string is first lowercased. When combined with the doAll argument, this is especially useful to clean user input of names when they are all UPPERCASE, e.g. converting "SUSI Q. SORGOLIS" to "Susi Q. Sorgolis" while preserving the CaSe if the input is e.g. "Ronald McDonald" |  |

# Examples

```cfml
	string = "submitting bugs and FEATURE requests via our online system";
	writedump(string.UcFirst());
	writedump(string.UcFirst( false, true));
	string = "SUBMITTING BUGS AND FEATURE REQUESTS VIA OUR ONLINE SYSTEM";
	writedump(string.UcFirst( true, true));
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[UcFirst()](../../functions/ucfirst.md), [String](../string.md)