# string.toBase64()

Calculates the Base64 representation of a string or binary
        object. The Base64 format uses printable characters, allowing
        binary data to be sent in forms and e-mail, and stored in a
        database or file.

```
string.toBase64( encoding=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| encoding | string | No | For a string, defines how characters are represented in a byte array. |  |

# Examples

```cfml
	res = "I love Lucee";
	writeDump(res.toBase64()); // SSBsb3ZlIEx1Y2Vl

	writeDump("ToBase64".toBase64()); // VG9CYXNlNjQ=
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[ToBase64()](../../functions/tobase64.md), [String](../string.md)