# string.spanIncluding()

Gets characters from a string, from the beginning to a
character that is not in a specified set of characters. The
search is case-sensitive.

```
string.spanIncluding( set=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| set | string | Yes | A string or a variable that contains a set of characters. Must contain one or more characters |  |

# Examples

```cfml
	str="AabByyysss";
	writeDump(str.spanincluding("AabsBy"));
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[SpanIncluding()](../../functions/spanincluding.md), [String](../string.md)