# string.spanExcluding()

Gets characters from a string, from the beginning to a
character that is in a specified set of characters. The
search is case-sensitive.

```
string.spanExcluding( set=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| set | string | Yes | A string or a variable that contains a set of characters. Must contain one or more characters |  |

# Examples

```cfml
	str="AabByyysss";
	writeDump(str.spanExcluding("B"));
	str="AabByyysss";
	writeDump(str.spanExcluding("y"));
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[SpanExcluding()](../../functions/spanexcluding.md), [String](../string.md)