# string.some()

This function calls a given closure/function with every element in a given string and returns true, if one of the closure calls returns true.

**Introduced:** 6.0.0.126

```
string.some( closure=function )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | No | The value to find or a closure/function that gets every value of the array as input and returns true if the given value is right. *Alias: function, callback, udf* |  |

# Examples

```cfml
	myString="lucee";
	callback=(x)=>x >= 'a';
	writeDump(myString.some(callback));

	callback_1=(x)=>x >= 'z';
	writeDump( myString.some(callback_1));
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[StringSome()](../../functions/stringsome.md), [String](../string.md)