# string.sanitizeHTML()

Sanitizes unsafe HTML input and removes elements and attributes like JavaScript, onclick, etc.

See also [OWASP Java HTML Sanitizer](https://github.com/OWASP/java-html-sanitizer)

```
string.sanitizeHTML( policy=any )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| policy | any | No | Either a org.owasp.html.PolicyFactory or a String with built in Sanitizers. If omitted then all of the built-in policies are applied. The built in Sanitizers are: - FORMATTING - BLOCKS - STYLES - LINKS - TABLES - IMAGES |  |

# Examples

```cfml
    html = '<!DOCTYPE html><html><body><h2>HTML Forms</h2><form action="/action_page.cfm"><label for="fname">First name:</label><br><input type="text" id="fname" name="fname"value="Pothys"><br><br><br><input type="submit" value="Submit">
    </form><p>If you click the "Submit" button, the form-data will be sent to a page called "/action_page.cfm".</p></body></html>';
    writeDump(var=html, label='html');
    test = html.sanitizeHTML();
    writeDump(var=test, label='string.SanitizeHtml');
```

# Categories

[Strings](../../../categories/string.md), [Encode/Decode](../../../categories/esapi.md), [HTML](../../../categories/html.md)

# See Also

[SanitizeHtml()](../../functions/sanitizehtml.md), [String](../string.md)