# string.rEReplace()

Uses a regular expression (RE) to search a string for a string
pattern and replace it with another. The search is
case-sensitive.

```
string.rEReplace( regex=string, substring=string, scope=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| regex | string | Yes | Regular expression to replace. *Alias: reg_expression* |  |
| substring | string | Yes | replacement |  |
| scope | string | No | - one (default): Replace the first occurrence of the regular expression. - all: Replace all occurrences of the regular expression. |  |

# Examples

```cfml
str = "count the NUMBERS 123... or ONE,TWO,THREE";
res = str.rereplace("[0-9]+","[one,two,three]","all");
writeDump(res);
res = str.rereplace("[a-z]+","1","all");
writeDump(res);
res = str.rereplace("[a-z]","1","all");
writeDump(res);
res = str.rereplace("[a-z]+","I Love Lucee","all");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Regex](../../../categories/regex.md)

# See Also

[REReplace()](../../functions/rereplace.md), [String](../string.md)