# string.replaceNoCase()

Replaces occurrences of `substring1` with `substring2`, in the specified scope. 

The search is case-insensitive.

```
string.replaceNoCase( substring=any, replacement=string, scope=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| substring | any | Yes | Substring for which to search. Optionally pass a Struct with key/value pairs to do a replace all *Alias: substring1* |  |
| replacement | string | No | Substring with which to replace the found matches. This arg is required if the substring1 arg is a string *Alias: substring2* |  |
| scope | string | No | scope for the execution: - one (default): Replace the first occurrence - all: Replace all occurrences |  |

# Examples

```cfml
str = "Lucee";
res = str.replacenocase("U","U","all");
writeDump(res);
res = str.replacenocase("l","Love L","all");
writeDump(res);
res = str.replacenocase("L","","all");
writeDump(res);
res = str.replacenocase("lUCEE","I Love Lucee","all");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[ReplaceNoCase()](../../functions/replacenocase.md), [String](../string.md)