# string.replaceListNoCase()

Replaces occurrences of the elements from a delimited list
in a string with corresponding elements from another delimited
list. The search is NOT case-sensitive.

```
string.replaceListNoCase( list1=string, list2=string, delimiter_list1=string, delimiter_list2=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list1 | string | Yes | string list of search strings |  |
| list2 | string | Yes | string list of replacement strings |  |
| delimiter_list1 | string | No | Delimiter for search, or if no replacement delimiter is defined, this delimiter is used for search and replacement. *Alias: delimiter, delimiterList1* |  |
| delimiter_list2 | string | No | Delimiter for replacement. *Alias: delimiterList2* |  |
| includeEmptyFields | boolean | No | When true, empty elements are preserved |  |

# Examples

```cfml
	str="xxxAbCdefghijxxXabcDefghij";
	writeDump(str.replaceListNoCase('A,b,c,d,E,f,g,H,i,J', '0,1,2,3,4,5,6,7,8,9'));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ReplaceListNoCase()](../../functions/replacelistnocase.md), [String](../string.md)