# string.replaceList()

Replaces occurrences of the elements from a delimited list in a string, with corresponding elements from another delimited list.

The search is case-sensitive.

```
string.replaceList( list1=string, list2=string, delimiter_list1=string, delimiter_list2=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| list1 | string | Yes | string list of search strings |  |
| list2 | string | Yes | string list of replacement strings |  |
| delimiter_list1 | string | No | Delimiter for search, or if no replacement delimiter is defined, this delimiter is used for search and replacement. *Alias: delimiter, delimiterList1* |  |
| delimiter_list2 | string | No | Delimiter for replacement. *Alias: delimiterList2* |  |
| includeEmptyFields | boolean | No | When true, empty elements are preserved |  |

# Examples

```cfml
fruits = "apple,mango-papaya,lemon,grapes,mango-Apple,Mango-apple,mango";
res = fruits.replacelist("mango-papaya","Mango-Apple");
writeDump(res);
res = fruits.replacelist("apple","Mango@Apple");
writeDump(res);
res = fruits.replacelist("mango-papaya","Mango@Apple","@","-");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ReplaceList()](../../functions/replacelist.md), [String](../string.md)