# string.replace()

Replaces occurrences of `substring1` in a string with `substring2` in a specified scope.

The search is case-sensitive.

```
string.replace( substring=any, replacement=any, scope=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| substring | any | Yes | Substring for which to search. Optionally pass a Struct with key/value pairs to do a replace all *Alias: sub1, find, substring1* |  |
| replacement | any | No | Substring with which to replace the found matches. This arg is required if the substring1 arg is a string *Alias: sub2, repl, substring2* |  |
| scope | string | No | scope for the execution: - one (default): replaces only the first occurrence - all: replaces all occurrences |  |

# Examples

```cfml
str = "Lucee";
res = str.replace("U","U","all");
writeDump(res);
res = str.replace("l","l","all");
writeDump(res);
res = str.replace("L","","all");
writeDump(res);
res = str.replace("Lucee","I Love Lucee");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[Replace()](../../functions/replace.md), [String](../string.md)