# string.REMatchNoCase()

Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.

```
string.REMatchNoCase( reg_expression=string, multiline=boolean )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| reg_expression | string | Yes | Regular expression for which to search. Case-insensitive. *Alias: regex* |  |
| multiline | boolean | No | If true indicate the regular expression should treat input as having multiple lines. This option affects the interpretation of the ^ and $ metacharacters. When true the ^ metacharacter matches at the beginning of every line, and the $ metacharacter matches at the end of every line. Additionally the . metacharacter will not match newlines when true. |  |

# Examples

```cfml
str = "count 1234 or one,two,three,four.."
res = str.rematchnocase("[A-Z]+");
writeDump(res);
res = str.rematchnocase("[a-z]+");
writeDump(res);
res = str.rematchnocase("(0-4)");
writeDump(res);
res = str.rematchnocase("[0-4]*");
writeDump(res);
res = str.rematchnocase("[0-9]+");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Regex](../../../categories/regex.md)

# See Also

[REMatchNoCase()](../../functions/rematchnocase.md), [String](../string.md)