# string.REMatch()

Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.

```
string.REMatch( regex=string, multiline=boolean )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| regex | string | Yes | Regular expression for which to search. Case sensitive. *Alias: reg_expression* |  |
| multiline | boolean | No | If true indicate the regular expression should treat input as having multiple lines. This option affects the interpretation of the ^ and $ metacharacters. When true the ^ metacharacter matches at the beginning of every line, and the $ metacharacter matches at the end of every line. Additionally the . metacharacter will not match newlines when true. |  |

# Examples

```cfml
str = "count 1234 or one,two,three,four.."
res = str.rematch("[a-z]+");
writeDump(res);
res = str.rematch("[a-z]");
writeDump(res);
res = str.rematch("[0-9]");
writeDump(res);
res = str.rematch("[0-9]+");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Regex](../../../categories/regex.md)

# See Also

[REMatch()](../../functions/rematch.md), [String](../string.md)