# string.reFindNoCase()

Uses a regular expression (RE) to search a string for a pattern,
starting from a specified position. The search is
case-insensitive.

```
string.reFindNoCase( reg_expression=string, start=number, returnSubExpressions=boolean, scope=string, multiline=boolean )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| reg_expression | string | Yes | Regular expression for which to search. Case-insensitive. |  |
| start | number | No | A positive integer. Position in the string at which to start search. The default value is 1. |  |
| returnSubExpressions | boolean | No | True: if the regular expression is found, the first array element contains the length and position, respectively, If the regular expression contains parentheses that group subexpressions, each subsequent array element contains the length and position, respectively, of the first occurrence of each group. If the regular expression is not found, the arrays each contain one element with the value 0. False: the function returns the position in the string where the match begins. Default. |  |
| scope | string | No | One: (Default)Returns the first value that matches the regex All: Returns all values that match the regex |  |
| multiline | boolean | No | If true indicate the regular expression should treat input as having multiple lines. This option affects the interpretation of the ^ and $ metacharacters. When true the ^ metacharacter matches at the beginning of every line, and the $ metacharacter matches at the end of every line. Additionally the . metacharacter will not match newlines when true. |  |

# Examples

```cfml
	writedump("1212 aAbBcCdD".reFindnocase("[a-z]+",6,"true"));
	writedump("1212 aAbBcCdD".reFindnocase("[a-z]+",6,"true")['len'][1]);
	writedump("1212 aAbBcCdD".reFindnocase("[a-z]+",6,"false"));
```

# Categories

[Strings](../../../categories/string.md), [Regex](../../../categories/regex.md)

# See Also

[REFindNoCase()](../../functions/refindnocase.md), [String](../string.md)