# string.reFind()

Uses a Regular Expression (RE) to search a string for a pattern. 

The search is case sensitive.

```
string.reFind( reg_expression=string, start=number, returnSubExpressions=boolean, scope=string, multiline=boolean )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| reg_expression | string | Yes | Regular expression for which to search. Case sensitive. |  |
| start | number | No | A positive integer. Position in the string at which to start search. The default value is 1. |  |
| returnSubExpressions | boolean | No | Default: false, If set true means returns the result as a struct with keys pos, match and len. Each are an array with elements for the position and length of the match (first element), and the position and length of any matched subexpressions in the subsequent elements. |  |
| scope | string | No | One: (Default)Returns the first value that matches the regex All: Returns all values that match the regex |  |
| multiline | boolean | No | If true indicate the regular expression should treat input as having multiple lines. This option affects the interpretation of the ^ and $ metacharacters. When true the ^ metacharacter matches at the beginning of every line, and the $ metacharacter matches at the end of every line. Additionally the . metacharacter will not match newlines when true. |  |

# Examples

```cfml
	writeDump("test 123!".reFind("[0-9]+"));
    writeDump("test 123".reFind("[0-9]+",7,true));
```

# Categories

[Strings](../../../categories/string.md), [Regex](../../../categories/regex.md)

# See Also

[REFind()](../../functions/refind.md), [String](../string.md)