# string.reduce()

Iterates over every element of the string and calls the closure to work on the elements of the string. This function will reduce the string to a single value and will return the value.

**Introduced:** 6.0.0.105

```
string.reduce( closure=function, initialVal=any )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | Closure or a function reference that will be called for each of the iteration. *Alias: function, callback, udf* |  |
| initialVal | any | No | Initial value that will be used for the reduce operation. *Alias: initial, initalValue* |  |

# Examples

```cfml
letters="abcdef";
closure=function(value1,value2){return value1 & value2;}
writeOutput( letters.reduce(closure,"z") );
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[StringReduce()](../../functions/stringreduce.md), [String](../string.md)