# string.parseDateTime()

Parses a date/time string according to the English (U.S.) locale conventions.

To format a date/time string for other locales, use the [LSParseDateTime()](../../functions/lsparsedatetime.md) function.

```
string.parseDateTime( format=string, timezone=timezone )
```

**Returns:** datetime

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| format | string | No | The format (Java Syntax) of the string. This string is used to parse the given date string to date time object. For details see <https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html> *Alias: popConversion* |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone, it is only an offset in milliseconds from 1970-1-1 00.00:00 UTC (Coordinated Universal Time). This means that the timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is since those calculations depend on the timezone. For these calculations, a timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function setTimezone. You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
<cfset dateTimeVar = #dateTimeFormat(now(), "yyyy.MM.dd HH:nn:ss ")# />
<cfoutput>
	<div> #dateTimeVar.parseDateTime()# </div>
</cfoutput>
```

# Categories

[Date and time](../../../categories/datetime.md), [Parsing](../../../categories/parsing.md), [Strings](../../../categories/string.md)

# See Also

[ParseDateTime()](../../functions/parsedatetime.md), [String](../string.md)