# string.MarkdownToHTML()

Transforms Markdown formatted String into HTML.

**Introduced:** 6.0.0.150

```
string.MarkdownToHTML( safeMode=boolean, encoding=string )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| safeMode | boolean | No | If set to true it does escape unsafe HTML tags *Alias: safe* |  |
| encoding | string | No | Charset, only used in case the argument markdown contains a file path *Alias: charset* |  |

# Examples

```cfml
nl= chr(10);
dNL= nl & nl;

markdownString="" & 
"## Heading1"  & dNL &
"###### Simple Paragraph"  & dNL &
"Some simple paragraph with a simple text"  & dNL &
"###### Ordered List"  & dNL &
"- First item" & nl &
"- Second item" & nl &
"- Third item" & dNL &
"###### Some Blockquotes"  & dNL &
"> This is some blockquoted text" & nl &
">> Blockquoted text with indentation" & dNL;

echo( markdownString.markdownToHtml() );
```

# Categories

[Strings](../../../categories/string.md)

# See Also

[MarkdownToHtml()](../../functions/markdowntohtml.md), [String](../string.md)