# string.lJustify()

Left justifies characters in a string of a specified length.

```
string.lJustify( length=number )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| length | number | Yes | Length of field in which to justify string |  |

# Examples

```cfml
   name = "yoyo".ljustify(10);
   writeDump(name);
   writeDump(len(name));
   writeDump(len(trim(name)));
   writeDump(len(ltrim(name)));
   writeDump(len(rtrim(name)));

	writeoutput("<hr>");
    s = "";
    res = s.lJustify(4);
    writeDump(len(res));
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "abc";
    res = s.lJustify(4);
    writeDump(len(res));
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "10";
    res = s.lJustify(4);
    writeDump(len(res));
    writeoutput("<pre>|#res#|</pre>");

```

# Categories

[Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md)

# See Also

[LJustify()](../../functions/ljustify.md), [String](../string.md)