# string.listValueCount()

Counts instances of a specified value in a list. The search is
case-sensitive.

```
string.listValueCount( value=string, delimiter=string, includeEmptyFields=boolean )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | string | Yes | Item for which to search |  |
| delimiter | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiters* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	List = "lucee,ACF,luceeExt,lucee,lucee, ext,LUCEEEXT";
	writeDump(list.ListValueCount("lucee"));
	writeDump(ListValueCount(list, "luceeExt"));
	writeoutput("<br>");
	List2 = "lucee@ACF@luceeExt@lucee@ext@LUCEEEXT";
	writeDump(list2.ListValueCount("lucee", "@"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListValueCount()](../../functions/listvaluecount.md), [String](../string.md)