# string.listToArray()

Copies the elements of a list to an array.

```
string.listToArray( delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiter | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiters* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. The default is false. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: `red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet.` |  |

# Examples

```cfml
list = "apple,mango-papaya,lemon,,,,grapes,mango-Apple,Mango-apple,mango";
//This is the list value
writeDump(list);
//This is after converting into ListtoArray
writeDump(list.ListtoArray());
writeDump(list.ListtoArray("-",true));
writeDump(list.ListtoArray(",-",false,true));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md), [Arrays](../../../categories/array.md)

# See Also

[ListToArray()](../../functions/listtoarray.md), [String](../string.md)