# string.listSort()

Sorts list elements according to a sort type and sort order.

```
string.listSort( sort_type=string, sort_order=string, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| sort_type | string | No | there are different sort types: - numeric (sort by number) - text (sorts text alphabetically and case sensitive) - textnocase (sorts text alphabetically and ignore case sensitivity) *Alias: sortType* |  |
| sort_order | string | No | sort direction: - asc(default): ascending sort order - desc: descending sort order |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	numericList = "-1,-9,-6,5,0,2,8";
	writedump(numericList.listsort("numeric","asc"));
	writeoutput("<br>");
	strList = "Adobe,coldfusion,lucee,15,LAS";
	writedump(strList.listsort("text","asc"));
	writeoutput("<br>");
	strListOne = "Adobe@coldfusion@lucee@15@LAS";
	writedump(strListOne.listsort("textnocase","asc","@"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md), [Sorting](../../../categories/sort.md)

# See Also

[ListSort()](../../functions/listsort.md), [String](../string.md)