# string.listSome()

This function calls a given closure/function with every element in a given string list and returns true, if one of the closure calls returns true.

```
string.listSome( closure=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor [function(any value, numeric index,string list, string delimiter):boolean]. *Alias: function, callback, udf* |  |
| delimiter | string | No | delimiter used to separate the string list |  |
| includeEmptyFields | boolean | No | include empty fields or not |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	list=",,a,,b,c,,e,f";
	res=list.ListSome( function(value ){return value !='a';},',',false,true, true);
	writeDump(res);
	res=list.ListSome( function(value ){return value =='z';},',',false,true,false);
	writeDump(res);
```

# Categories

[Lists](../../../categories/list.md), [Iterator](../../../categories/iterator.md), [Strings](../../../categories/string.md), [Threads](../../../categories/thread.md)

# See Also

[ListSome()](../../functions/listsome.md), [String](../string.md)