# string.listSetAt()

Replaces the contents of a list element.

```
string.listSetAt( position=number, value=string, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| position | number | Yes | Position at which to set a value. The first list position is 1. |  |
| value | string | Yes | An element or a list of elements to set. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
fruits = "apple,mango-papaya,lemon,grapes,mango-Apple,Mango-apple,mango";
res = fruits.listsetat("2","potato");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListSetAt()](../../functions/listsetat.md), [String](../string.md)