# string.listRest()

Gets a list, without its first element.

```
string.listRest( delimiters=string, includeEmptyFields=boolean, offset=number )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |
| offset | number | No | specifies how many items to skip from the beginning of the list. default is 1. |  |

# Examples

```cfml
	strList="0,1,2,3,4";
	writeDump(strlist.listRest());
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListRest()](../../functions/listrest.md), [String](../string.md)