# string.listRemoveDuplicates()

Removes duplicate values from list.

```
string.listRemoveDuplicates( delimiters=string, ignoreCase=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| ignoreCase | boolean | No | if set to true, the duplicate value test will not be case sensitive |  |

# Examples

```cfml
list = "apple,mango-papaya,lemon,grapes,mango-Apple,Mango-apple,mango";
res = list.listremoveduplicates();
writeDump(res);
res = list.listremoveduplicates(",",true);
writeDump(res);
res = list.listremoveduplicates("-",true);
writeDump(res);
res = list.listremoveduplicates("-");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListRemoveDuplicates()](../../functions/listremoveduplicates.md), [String](../string.md)