# string.listReduce()

Iterates over every entry of the given list and calls the closure with every element.

This function will reduce the list to a single value and will return the value.

```
string.listReduce( closure=function, initialValue=object, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor `function(any result, object value, numeric index, string list, string delimiter){ return result; }` *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |
| delimiter | string | No | delimiter used to separate the string list |  |
| includeEmptyFields | boolean | No | include empty fields or not |  |
| multiCharacterDelimiter | boolean | No | Specifies whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the [ListToArray()](../../functions/listtoarray.md) function to convert a list such as the following to an array of color names: `red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet.` |  |

# Examples

```cfml
	numbers = "1,3,5,7";
	reducedVal = numbers.listReduce( function(previousValue, value)
	{
		return previousValue + value;
	},0);
	writeOutput("The sum of the digits #numbers# is #reducedVal#");
```

# Categories

[Lists](../../../categories/list.md), [Iterator](../../../categories/iterator.md), [Strings](../../../categories/string.md), [Threads](../../../categories/thread.md)

# See Also

[ListReduce()](../../functions/listreduce.md), [String](../string.md)