# string.listQualify()

Inserts a string at the beginning and end of list elements.

```
string.listQualify( qualifier=string, delimiters=string, elements=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| qualifier | string | Yes | string to insert before and after the list elements specified in the elements parameter. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| elements | string | No | which type of element are qualified - all (default): all elements - char: elements that are composed of alphabetic characters |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	strList="Lucee,ColdFusion,LAS,SUSI";
	writeDump(strlist.listQualify('|'));

	strList="Lucee\ColdFusion\LAS\SUSI";
	writeDump(strlist.listQualify('|',"\"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListQualify()](../../functions/listqualify.md), [String](../string.md)