# string.listPrepend()

Inserts an element at the beginning of a list.

```
string.listPrepend( value=string, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | string | Yes | An element or a list of elements. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if false it cleans up empty fields. |  |

# Examples

```cfml
fruits = "apple,mango-papaya,lemon,grapes,mango-Apple,Mango-apple,mango";
writeDump(fruits);
res = fruits.listprepend("jerry");
writeDump(res);
res = fruits.listprepend("tomato");
writeDump(res);
res = fruits.listprepend("tomato","-");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListPrepend()](../../functions/listprepend.md), [String](../string.md)