# string.listMap()

Calls the given closure with every element in the given list.

the function returns an list that contains all values returned by the closure.

```
string.listMap( closure=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | filter can be a function/closure that implements the following constructor [function(any value, number index, string list, string delimiter):any]. *Alias: function, callback, udf* |  |
| delimiter | string | No | delimiter used to separate the string list |  |
| includeEmptyFields | boolean | No | include empty fields or not |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	language = "java,Lucee,javascript,jquery";
	externalList = "";
	reverselanguage = listMap( language, function(v,i,l) {
		var newValue = "#i#:#v.right(5)#";
		externalList = listappend(externalList,newValue);
		return newValue;
	});
	writeDump([{language=language},{reverselanguage=reverselanguage},{externalList=externalList}]);
```

# Categories

[Iterator](../../../categories/iterator.md), [Lists](../../../categories/list.md), [Strings](../../../categories/string.md), [Threads](../../../categories/thread.md)

# See Also

[ListMap()](../../functions/listmap.md), [String](../string.md)