# string.ListLen()

Determines the number of elements in a list.

```
string.ListLen( delimiters=string, includeEmptyFields=boolean )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	writedump("1,2,3".listlen());
	writeoutput("<Br>");
	writedump("i@love@@lucee".listlen("@",true));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListLen()](../../functions/listlen.md), [String](../string.md)