# string.listLast()

Gets the last element of a list.

```
string.listLast( delimiters=string, includeEmptyFields=boolean, count=number )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |
| count | number | No | specifies how many items to return from the end of the list. default is 1. |  |

# Examples

```cfml
	listlastEX1 = "one&two&three&four";
	writedump(listlastEX1.listlast('&'));
	writeoutput("<br>");
	listlastEX2 = "dev,LAS,lucee";
	writedump(listlastEX2.listlast(''));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListLast()](../../functions/listlast.md), [String](../string.md)