# string.listInsertAt()

Inserts an element in a list.

```
string.listInsertAt( position=number, value=string, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| position | number | Yes | Position at which to insert element. The first list position is 1. |  |
| value | string | Yes | An element or a list of elements. |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
list = "one,two,three,four,five";
res = list.listinsertat(3,"3");
writeDump(res);
res = list.listinsertat(4,"4");
writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListInsertAt()](../../functions/listinsertat.md), [String](../string.md)