# string.listIndexExists()

Determines if an element at the given position exists or not

```
string.listIndexExists( index=number, delimiter=string, includeEmptyFields=boolean )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| index | number | Yes | index to check for. |  |
| delimiter | string | No | Characters that separate list elements. The default value is comma. |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	list = "one, two, three, four, five";
	res = list.listindexexists(8);
	writeDump(res);

	list = "one, two, three, four, five";
	res = list.listindexexists(5);
	writeDump(res);
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListIndexExists()](../../functions/listindexexists.md), [String](../string.md)