# string.listGetAt()

Gets a list element at a specified position.

```
string.listGetAt( position=number, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| position | number | Yes | position of the element to return |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	strList = "lucee,core,dev";
	writeDump(strList.ListGetAt(2));
	writeOutput("<br>");
	writeDump("$2$3$41$5".ListGetAt(1,'$',true))
	writeOutput("<br>");
	strListdeli = "adobe@coldfusion@lucee@";
	writeDump(strListdeli.ListGetAt(1,"@"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListGetAt()](../../functions/listgetat.md), [String](../string.md)