# string.listFirst()

Gets the first element of a list.

```
string.listFirst( delimiters=string, includeEmptyFields=boolean, count=number )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |
| count | number | No | specifies how many items to return from the beginning of the list. default is 1. |  |

# Examples

```cfml
	listEx1 = "one&two&three&four";
	writedump(listEx1.listfirst('&'));
	writeoutput("<br>");
	listEx2 = "dev,LAS,lucee";
	writedump(listEx2.listfirst(''));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListFirst()](../../functions/listfirst.md), [String](../string.md)