# string.listFindNoCase()

Determines the index of the first list element in which a
specified value occurs

```
string.listFindNoCase( value=string, delimiters=string, includeEmptyFields=boolean )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | string | Yes | element for which to search |  |
| delimiters | string | No | Characters that separate list elements. The default value is comma. *Alias: delimiter* |  |
| includeEmptyFields | boolean | No | if set to true, empty values are included as well |  |

# Examples

```cfml
	strList = "lucee,core,dev";
	writeoutput(strList.listFindNoCase("Dev"));
	writeOutput("<br>");
	strListdeli = "adobe,coldfusion,lucee";
	writeoutput(strListdeli.listFindNoCase("ADOBE"));
```

# Categories

[Strings](../../../categories/string.md), [Lists](../../../categories/list.md)

# See Also

[ListFindNoCase()](../../functions/listfindnocase.md), [String](../string.md)