# string.listEvery()

This function calls a given closure/function with every element in a given string list and returns true, if all of the closure calls returns true.

```
string.listEvery( closure=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor [function(any value, numeric index, string list, string delimiter):boolean]. *Alias: function, callback, udf* |  |
| delimiter | string | No | delimiter used to separate the string list |  |
| includeEmptyFields | boolean | No | include empty fields or not |  |
| multiCharacterDelimiter | boolean | No | specifying whether the delimiters parameter specifies a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the ListToArray function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	fruits = "apple,pear,orange";
	fruits.ListEvery(function(value, index, list) {
		writeDump(index);
		writeDump(value);
		writeDump(list);
		return true;
	});
```

# Categories

[Iterator](../../../categories/iterator.md), [Lists](../../../categories/list.md), [Strings](../../../categories/string.md), [Threads](../../../categories/thread.md)

# See Also

[ListEvery()](../../functions/listevery.md), [String](../string.md)