# string.listEach()

call the given UDF/Closure with every value in the string list.

```
string.listEach( closure=function, delimiter=string, includeEmptyFields=boolean, multiCharacterDelimiter=boolean, parallel=boolean, maxThreads=number )
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor `function(element, index, list){}` *Alias: function, callback, udf* |  |
| delimiter | string | No | delimiter used to separate the string list |  |
| includeEmptyFields | boolean | No | include empty fields or not |  |
| multiCharacterDelimiter | boolean | No | specify whether the delimiters parameter is a multi-character delimiter. If this parameter is true, the delimiters parameter must specify a single delimiter consisting of multiple characters. This parameter enables the [ListToArray()](../../functions/listtoarray.md) function to convert a list such as the following to an array of color names: red:\|orange:\|yellow:\|green:\|blue:\|indigo:\|violet. |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	strList="I,Love,Lucee";
	strList.listEach(function(element,index,list) {
    	writeOutput("#index#:#element#;<br>");
	});
```

# Categories

[Iterator](../../../categories/iterator.md), [Lists](../../../categories/list.md), [Strings](../../../categories/string.md), [Threads](../../../categories/thread.md)

# See Also

[ListEach()](../../functions/listeach.md), [String](../string.md)